function [detectedSpikeTimesMS] = poorRoutineToFindSpikeTimes(timesMS,voltagesUV);
%
% [detectedSpikeTimesMS] = poorRoutineToFindSpikeTimes(timesMS,voltagesUV);
%
% 9.02 Brain lab routine.  Written by J.J. DiCarlo
%
% This function takes the following input data:
%   timesMS  = a vector where each element is a time in milliseconds (MS)
%   voltagesUV = a vector where each element is a voltage at a different time
%   
%   NOTE: the routine assumes that the voltage and timeMS vectors are in
%   correspondance, such that the first voltage element corresponds to the
%   first time, the second voltage element to the second time, etc.
%   This means that the vectors should have identical size (or something is
%   wrong and the routine cannot run).
%
% The function returns the following output data:
%   spikeTimesMS = a vector containing all the times (in millisecs) where a
%   spike (action potential) was detected.  The length of this vector (ie..
%   the number of elements in the vector) depends on data and can range from 
%   0 (i.e. no spikes detected) to length(timeMS)  (a spike at every time
%   point!)
%
% This function is not a good spike detector (as you will see below), 
%   but the definitions of the input and output data are good.
%

% -------------------------------------------------------------------------
% We first run some checks on the input data  

% here we check that the input data look reasonable
Nv = length(voltagesUV);  % the "length" function returns the number of elements in the vector
Nt = length(timesMS);  % hint: type "help length" (no quotes) in Command window

if (Nv == Nt) 
    % vectors have the same length.  Good!
else
    ['ERROR:  vectors do not have the same length']
    spikeTimesMS = [];      %% empty vector
    return;                 %% return early 
end

% what other checks might one want to do on this data??
% ..

% end check of input data.  We now think we have good data to work with.
% -------------------------------------------------------------------------


% -------------------------------------------------------------------------
% the "meat" of our spike detector is in the next set of commands:

% here we run operations and call MATLAB function to detect spikes

maxTimeMS = max(timesMS);       % find the maximum time in the input data
                                %  This value should probably be the same as
                                %  "timesMS(length(timesMS))".  why?

r1 = rand(1,1);                     % a random real number between 0 and 1.0
randomInteger = round(r1*Nt*0.01);   % a random integer between 0 and (0.01*Nt)
numSpikesDetected = randomInteger;  % now you see why it is a poor spike detector!


r2 = rand(1,numSpikesDetected); % a vector with numSpikesDetected elements
                                %  (each element is a random real number between
                                %  0.0 and 1.0)                               
detectedSpikeTimesMS = round(r2*maxTimeMS);  % a vector of random times between 0 and maxTimeMS

%% look carefully at the last two lines.  MATLAB is very good at working with
%% vectors.  We could have also written this like this:
%
%   for i = 1:numSpikesDetected
%       spikeTimesMS(i) = round(rand(1,1)*maxTimeMS)
%   end
% 
%% This would give the same result (except for the randomness).
%% But it would run much more slowly and is less elegant.


detectedSpikeTimesMS = sort(detectedSpikeTimesMS);      %% resort the times so that the earliest are first

% end spike detection section of the routine
% -------------------------------------------------------------------------



% -------------------------------------------------------------------------
%% Note:  the entire routine could have been written like this!
%
% spikeTimesMS = sort(round((max(timesMS))*(rand(1,round(rand(1,1)*length(timesMS)))));  
%
%% This line has the exact same functionality, but it is much harder to read!
% -------------------------------------------------------------------------


return;     % we are finished 
%             the vector "spikeTimesMS" has been created and will be
%             returned as specified in the first line of the function




